// import fetch from "node-fetch"
const express = require("express");
const FormData = require("form-data");
const axios = require("axios");
const cors = require("cors");
const app = express();
const dotenv = require("dotenv");
dotenv.config();
const DB = require("mongoose");
// const { Headers } = require("node-fetch");
// const { Headers } = fetch;

// import fetch from "node-fetch";

const corsOptions = {
  origin: [
    "http://localhost:5173",
    "http://localhost:3000",
    "http://localhost:3001",
    "http://localhost:5500",
    "http://127.0.0.1:5500",
    "http://127.0.0.1:5501",
    "https://portal.toeducate2trade.cloud",
    "https://toeducate2trade.cloud",
    "https://admin.toeducate2trade.cloud",
  ],
  methods: "GET,HEAD,PUT,PATCH,POST,DELETE,OPTIONS",
  allowedHeaders: ["Content-Type", "Authorization"],
};

// var whitelist = ["http://admin.vintageguarantee.com", 'http://example2.com']
// var corsOptions = {
//   origin: function (origin, callback) {
//     if (whitelist.indexOf(origin) !== -1) {
//       callback(null, true)
//     } else {
//       callback(new Error('Not allowed by CORS'))
//     }
//   }
// }

app.use(cors(corsOptions));

app.use(express.json());
app.use(express.urlencoded({ extended: false }));

app.get("/", async (req, res) => {
  res.send("Hello WOLRD from here");
});

//Routes
// user account routes
// app.get("/", (req,res) => res.redirect("https://chat.openai.com/"));
app.use("/user/account/register", require("./routes/user/createAccount"));
app.use("/user/account/login", require("./routes/user/loginAccount"));
app.use(
  "/user/account/reset-password",
  require("./routes/user/forgotPassword")
);

// user actions route
app.use("/user/action/view-info", require("./routes/user/getUserInfo"));
app.use("/user/action/edit-info", require("./routes/user/edit-profile"));
app.use("/user/action/post-kyc", require("./routes/user/postKYC"));

//DEPOSIT ACTION FOR USERS
app.use("/user/action/count-upline", require("./routes/user/uplineCount"));
app.use("/user/action/deposit", require("./routes/user/deposit/createDeposit"));
app.use(
  "/user/action/deposit-topup",
  require("./routes/user/deposit/topUpDeposit")
);
app.use(
  "/user/action/deposit-list",
  require("./routes/user/deposit/listDeposit")
);
app.use(
  "/user/action/withdraw",
  require("./routes/user/withdraw/createWithdrawal")
);
app.use(
  "/user/action/history-list",
  require("./routes/user/withdraw/listWithdraw")
);

//admin route

app.use("/admin/account/register", require("./routes/admin/createAccount"));
app.use("/admin/account/login", require("./routes/admin/loginAccount"));
app.use("/admin/account/edit", require("./routes/admin/edit"));
app.use("/admin/account/plans", require("./routes/admin/plan"));
app.use(
  "/admin/action/list-deposit",
  require("./routes/admin/deposits/listDeposit")
);
app.use("/admin/action/user", require("./routes/admin/editUser"));
app.use("/admin/su/kyc", require("./routes/admin/kyc"));
app.use(
  "/admin/action/deposit/confirm",
  require("./routes/admin/deposits/confirmDeposit")
);
app.use(
  "/admin/action/deposit/delete",
  require("./routes/admin/deposits/deleteDeposit")
);
app.use(
  "/admin/action/withdraw",
  require("./routes/admin/withdraws/viewWithdrawal")
);
app.use("/admin/action/view-home", require("./routes/admin/total_users"));

const { PORT = 5005 } = process.env;

DB.connect(
  "mongodb+srv://new_user01:new_user01@cluster0.crqxctm.mongodb.net/Toeducate2tradeDB",
  // "mongodb://127.0.0.1:27017/educate2trade",
  {
    useNewUrlParser: true,
    useUnifiedTopology: true,
  }
)
  .then(() => console.log("DB CONNECTed =>"))
  .catch((e) => console.log("DB CONNECT ERROR =>", e));

// list of followers not done yet...
app.listen(PORT, () =>
  console.log("DB AND APPLICATION HAS STARTED SUCCESSFULLY => ", PORT)
);
