const jsonwebtoken = require('jsonwebtoken');
const UserModel = require('../model/user');
const {sgMail} = require('./mailer');

const CheckUpline = async (req, res, next) => {
  // TRY BLOCK
  try {
    const findUpline = await UserModel.findOne({
      username: req.body.upline.toLowerCase(),
    });
    if (!findUpline) {
      return next();
    }
    const calc = parseInt(findUpline.referral) + 1;
    // if found, update the upline user
    await UserModel.findOneAndUpdate(
      {_id: findUpline._id},
      {
        referral: calc,
      },
      {new: true}
    );

    // console.log("findUpline._doc.email UPLINE EMAIL => ", findUpline._doc.email);

    // FIXME: SEND EMAIL TO USER WITH SENDGRID
    // body: `You have a direct signup. ${findUpline._doc.full_name} signup with your referral link`,
    await sgMail.send({
      from: 'Admin <support@megacoins-investment.com>',
      to: findUpline._doc.email,
      subject: 'Registration Info',
      html: `
            <table class="m_8716275206429255507flexible" style="margin: 0 auto" width="600" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td bgcolor="#ffffff">
            <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td class="m_8716275206429255507img-flex"><img src="https://megacoins-investment.com/logo.png" width="600" height="200"></td>
            </tr><tr><td style="padding: 40px 25px">
            <h1>You have a direct signup. ${req.body.full_name} used your referral link to create an account. His details are below </h1>
            <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Details are blow </td>
            </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Thank you for choosing <strong style="color: #12326b">Mega Coins</strong> </td>
            </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">To start earning, <strong style="color: #12326b">subscribe to a plan</strong> and start making profits!! .</td>
            </tr><tr>
            </tr><tr><td style="padding: 40px 15px; border-radius: 10px" bgcolor="#F2F2F2">
            <table width="100%" cellspacing="0" cellpadding="0"><tbody>
              
              <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #12326b" align="center">Full Name</td>
            </tr>
              
              <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px" align="center">${req.body.full_name}</td>
            </tr>
      
      
            <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #12326b" align="center">Username</td>
            </tr>
              
              <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px" align="center">${req.body.username}</td>
            </tr>
      
      
            <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #12326b" align="center">Email</td>
            </tr>
              
              <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px" align="center">${req.body.email}</td>
            </tr>
      
      
            </tr>
            <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #12326b" align="center">Login Here</td>
            </tr>
              <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px" align="center"><a href='https://megacoins-investment.com/'>click here</a> </td>
            </tr>
            </tbody></table></td>
            </tr>
              <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Don't recognize this activity? <a style="color: #0091ff; text-decoration: none" href="https://megacoins-investment.com/" rel="noreferrer" target="_blank">Report it</a> immediately.</td>
            </tr>
              <tr><td class="m_8716275206429255507h-u" style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000">To the moon 🚀<br> Team Mega Coins<br><br> Questions? Visit the <a style="color: #0091ff; text-decoration: none" href="https://megacoins-investment.com/" rel="noreferrer" target="_blank">Help Centre</a>.</td>
            </tr></tbody></table></td>
            </tr>
            </tbody></table></td>
            </tr></tbody></table></td>
            </tr></tbody></table></td>
            </tr></tbody></table>`,
    });
    next();
  } catch (error) {
    // CATCH BLOCK FOR EXCEPTIONS
    console.log('error catch from checkUpline => ', error);
    return res
      .status(500)
      .json({
        error: true,
        msg: 'opps!!!, session expired, please login to continue.',
        data: null,
        e: error,
      });
  }
};

module.exports = CheckUpline;
