const { Schema, model } = require("mongoose");
const moment = require("moment");

const DepositModel = new Schema(
  {
    date: {
      type: String,
      default: moment().format("lll"),
    },
    amount: {
      type: Number,
      required: true,
    },
    status: {
      type: String,
      enum: ["pending", "processing", "completed", "canceled", "approved"],
      default: "pending",
    },
    type: {
      type: String,
      enum: ["deposit", "withdrawal"],
      default: "deposit",
    },
    plan: {
      type: Object,
      required: true,
      // FIXME: propagate the plan in sync with db
    },
    wallet: {
      type: String,
      default: "bitcoin",
    },
    remark: {
      type: String,
      default: "Deposit request processed to admin",
    },
    uid: {
      type: Schema.Types.ObjectId,
      ref: "user", //reference to the user schema
    },
  },
  {
    timestamps: true,
  }
);

module.exports = model("deposit_schema", DepositModel);
