const { Schema, model, mongoose } = require("mongoose");
const moment = require("moment");

const kycModel = new Schema(
  {
    is_read: { type: Boolean, default: false },
    uid: { type: mongoose.Schema.Types.ObjectId, ref: "users" },
    date: { type: String, default: moment().format("lll") },
    photo: String,
    image: {
      select: false,
      type: Object,
    },
    full_name: String,
    email: String,
    country: String,
    phone: String,
    address: String,
    zip: String,
    dob: String,
    id_card_type: String,
    marital_status: String,
    status: {
      type: String,
      enum: ["pending", "approved", "suspended"],
      default: "pending",
    },
  },
  {
    timestamps: true,
  }
);
module.exports = model("kycs", kycModel);