// const {Schema, model, default: mongoose} = require('mongoose');
const moment = require('moment');
const {Schema, model} = require('mongoose');

// this schema handles a notification... with the reference of user for owner
const Notification = new Schema({
  obj: Array,
  note: String,
  owner: {type: Schema.Types.ObjectId, ref: 'user'},
  date: {
    type: String,
    default: moment().format('lll'),
  },
  read: {
    type: Boolean,
    default: false
  }
},{
  timestamps: true
});

module.exports = model('User_Notification', Notification);
