const {Schema, model} = require('mongoose');
const moment = require('moment');

const DepositModel = new Schema({
  amount: Number,
  plan: String,
  wallet: String,
  remark: String,
  earning: String,
  duration: String,
  time: String,
  currentTime: String,
  expiryTime: String,
  expired: Boolean,
  claimed: Boolean,
  addedAmount: Number,
  user: {
    type: Schema.Types.ObjectId,
    ref: 'user', //reference to the user schema
  },
},{
  timestamps: true
});

module.exports = model('Running Deposit MegaCoins', DepositModel);
