const { Schema, model } = require("mongoose");
const moment = require('moment');


const WithdrawModel = new Schema({
    date:{
        type:String,
        default: moment().format('lll')
    },
    amount:{
        type: Number,
        required: true
    },
    
    pending: {
        type: Boolean,
        default:true,
    },
    
    wallet: {
        type: Object,
    },
    remark: {
        type: String,
        default: 'Withdrawal request processed to admin'
    },
    user: {
        type: Schema.Types.ObjectId,
        ref: 'user' //reference to the user schema 
    } 
},{
    timestamps: true
  });



module.exports = model('withdraw_mega_coin', WithdrawModel)