const nodeCron = require("node-cron");
const AuthAdmin = require("../../../middlewares/authAdmin");
const { sgMail } = require("../../../middlewares/mailer");
const deposit = require("../../../model/deposit");
// const { findOne } = require('../../../model/user');
const UserModel = require("../../../model/user");
const Router = require("express").Router();
const nodemailer = require("nodemailer");
const Notification = require("../../../model/notification");
const { Resend } = require("resend");

const resend = new Resend("re_5iuWo7UU_Lj319A3cxwY2ssQoG7gf539x");

// var transporter = nodemailer.createTransport({
//   host: "sandbox.smtp.mailtrap.io",
//   port: 2525,
//   auth: {
//     user: "3eb629bfef6a51",
//     pass: "9d8e3fd34e0778",
//   },
// });


var transporter = nodemailer.createTransport({
  // host: "server346.web-hosting.com",
  host: "server334.web-hosting.com",
  port: 465, //587
  auth: {
    user: "support@toeducate2trade.cloud",
    pass: "@toeducate2trade.cloud",
  },
});


// this middleware only updates the user if the have a referral
const AddReferralCommission = async (req, res, next) => {
  // const findUser = await UserModel.findOne({_id:req.user._id})

  //     // update the referral if any thats the first deposit and if the user has any upline => upline is the user username
  //     if(findUser.total_deposit < 1 && findUser.upline.toLowerCase() != 'system || no up line'){
  //         const findUpline = await UserModel.findOne({username: findUser.upline})
  //         if(!findUpline){
  //             next()
  //         }
  //         // update if found
  //         const calc = parseInt(findUpline.referral_commission) + 10
  //         await UserModel.findOneAndUpdate({_id: findUpline._id}, {
  //             referral_commission: calc,
  //             balance: parseInt(findUpline.balance) + 10
  //         }, {new:true})
  //         next()
  //     }
  //     next()

  try {
    let foundDeposit = await deposit.findOne({
      _id: req.params.deposit_id,
      status: "pending",
    });
    const findUser = await UserModel.findOne({ _id: req.params.user_id });

    if (!findUser || !foundDeposit) {
      return next();
    }

    if (foundDeposit.remark == "reinvestment") {
      return next();
    }

    // calcuateting the 5% for the upline
    const getTen = (await parseInt(foundDeposit.amount)) / 10;
    const getFive = (await getTen) / 2;

    // update the referral if any thats the first deposit and inewAmountf the user has any upline => upline is the user username
    // if(findUser.upline.toLowerCase() != 'system site'){
    const findUpline = await UserModel.findOne({ username: findUser.upline });
    if (!findUpline) {
      return next();
    }
    // update if found
    const calc = parseInt(findUpline.referral_commission) + getFive;

    const checkIfOwnerHasDepositedBefore = deposit.find({type: "deposit", uid: findUser._id})

    if(checkIfOwnerHasDepositedBefore.length > 0) {
      return next();
    }

    await UserModel.findOneAndUpdate(
      { _id: findUpline._id },
      {
        referral_commission: calc,
        bonus: calc,
        // balance: parseInt(findUpline.balance) + getFive,
      },
      { new: true }
    );
    console.log(
      "request reach here for comfirmation of deposit and giving upline his or her details => ",
      findUpline
    );
    // const createNot = await notification.create({
    //   obj: [
    //     {
    //       key: 'full name',
    //       value: findUser._doc.full_name,
    //     },
    //     {key: 'username', value: findUser._doc.username},
    //     {key: 'email', value: findUser._doc.email},
    //   ],
    //   note: `You've just earned $${getFive} with your referral link and your total  referral commission is $${calc}. Details are below`,
    //   // owner the person that owns this model
    //   owner: findUpline._id,
    // });

    const msg = {
      from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
      to: findUpline._doc.email,
      subject: "Referral Commission",
      html: `
      
      <table class="m_8716275206429255507flexible" style="margin: 0 auto" width="600" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td bgcolor="#ffffff">
              <table width="100%" cellspacing="0" cellpadding="0"><tbody>
              

          
          
          <tr><table  role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate; font-family: 'Inter'; min-width: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; margin: 0 auto; padding: 17px 60px; background-color: #ec632d;" width="100%">
          <tbody style="font-family: 'Inter';"><tr style="font-family: 'Inter';">
            <td class="align-center" style="font-family: 'Inter'; font-size: 14px;" valign="center" align="left">
              <a target="_blank" rel="noopener noreferrer" href="#" style="color: #5daf60; font-family: 'Inter'; text-decoration: underline;">
              <img src="https://toeducate2trade.cloud/logo.PNG" width="" height="82.45">
              </a>
            </td>
          </tr>
        </tbody></table></tr>
          
          
          
    

              <tr><td style="padding: 40px 25px">
              <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Dear ${findUpline._doc.full_name}</td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">You've just earned $${getFive} with your referral link and your total  referral commission is $${calc}.</td>
              </tr>

              <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Transaction details:</td>
              </tr><tr><td style="padding: 40px 15px; background-color: #ec632d; " bgcolor="#F2F2F2">
              <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Commission from </td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${findUser._doc.full_name}</td>
              </tr><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Username</td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${findUser._doc.username}</td>
              </tr></tbody></table></td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Don't recognize this activity? <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Report it</a> immediately.</td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">If you made a mistake sending this crypto <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">read this article</a> on what you can do.</td>
              </tr><tr><td class="m_8716275206429255507h-u" style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000">To the moon 🚀<br> TEAM TOEDUCATE2TRADE<br><br> Questions? Visit the <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Help Centre</a>.</td>
              </tr></tbody></table></td>
              </tr>

              </tbody></table></td>
              </tr></tbody></table></td>
              </tr></tbody></table></td>
              </tr></tbody></table>

      `,
    };
    const mailOptions = {
      from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
      to: msg.to,
      subject: msg.subject,
      html: msg.html,
    };

    const dataHere = await transporter.sendMail(mailOptions);

    const createNot = await Notification.create({
      obj: [
        {
          key: "Commission from",
          value: findUser._doc.full_name,
        },
        { key: "Username", value: findUser._doc.username },
        { key: "Total Referral Commission", value: `$${calc}` },
      ],
      note: `You've just earned $${getFive} with your referral link and your total referral commission is $${calc}. Transaction details are below `,
      // owner the person that owns this model
      owner: findUpline._id,
    });


    // const resendMsg = await resend.emails.send({
    //   from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
    //   to: msg.to,
    //   subject: msg.subject,
    //   html: msg.html,
    // });

    // console.log("resendMsg ==>> ", resendMsg);
    

    next();
    // }
    // next()
  } catch (error) {
    // CATCH BLOCK FOR EXCEPTIONS
    console.log("error catch from checkUpline => ", error);
    return res.status(500).json({
      error: true,
      msg: "Error catch from upline.",
      data: null,
      e: error,
    });
  }
};

// CONFIRM DEPOSIT BY A USER
Router.post(
  "/:deposit_id/:user_id",
  AddReferralCommission,
  AuthAdmin,
  async (req, res) => {
    try {
      let { deposit_id = "" } = req.params;
      let { newAmount } = req.body; //if admin wants to change the amount before confirmation
      //   const findUser = await UserModel.findOne({_id: req.params.user_id});
      let foundDeposit = await deposit
        .findOne({ _id: deposit_id, status: "pending" })
        .sort({ date: -1 })
        .populate("uid");
      // after check if the deposit exist
      if (!foundDeposit)
        return res.status(400).json({
          error: true,
          msg: "deposit does not exit, or already confirmed",
          data: null,
        });
      // ._construct.if the deposit is now found then adjust a few things in it
      let { amount, wallet, uid, earning } = foundDeposit._doc;
      if (newAmount) {
        await deposit.updateOne({ _id: deposit_id }, { amount: newAmount });
      }
      let { email } = uid;
      console.log(wallet + " " + email);
      // return null
      // update the user information and put everthing in running deposit
      await UserModel.updateOne(
        { email },
        {
          balance: parseInt(foundDeposit.uid.balance) + parseInt(amount),
          pending_deposit:
            parseInt(foundDeposit.uid.pending_deposit) - parseInt(amount),
          total_deposit:
            parseInt(foundDeposit.uid.total_deposit) + parseInt(amount),
          active_deposit: parseInt(foundDeposit.uid.active_deposit) + 1,
          active: true, //activate the user
        }
      );
      // after updating the user then update the deposit
      await deposit.updateOne({ _id: deposit_id }, { status: "completed" }); //update the deposit to not pending

      // //auto add earning to balance after 24hrs||  0 */12 * * * 12hrs ||  */1 * * * *
      // let taskID = nodeCron.schedule("0 */12 * * *", async () => {
      //   let userIn = await UserModel.findOne({ email });
      //   console.log("RUNNING CRON TAB");
      //   await UserModel.updateOne(
      //     { email },
      //     {
      //       balance: +userIn.balance + earning,
      //       total_earning: +userIn.total_earning + earning,
      //       // wallet: {
      //       //     ...userIn.wallet,
      //       //         [wallet]:{
      //       //             ...userIn.wallet[wallet],
      //       //             balance:userIn.wallet[wallet].balance+earning,

      //       //         }
      //       // }
      //     }
      //   );
      //   //kill task after 12hours of run
      //   taskID.stop();
      // });

      let userIn = await UserModel.findOne({ email });
      res.json({
        error: false,
        data: "Deposit has been confirmed and funds are sent to client",
        msg: null,
      });
      //FIXME:  send email to customer to notify them about the confirmation

        // sgMail.send({

    const msg = {
          from: 'Toeducate2trade Notification <support@toeducate2trade.cloud>',
          to: email,
          subject: 'Payment credited to your account successfully',
          html: `
          
          <table class="m_8716275206429255507flexible" style="margin: 0 auto" width="600" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td bgcolor="#ffffff">
              <table width="100%" cellspacing="0" cellpadding="0"><tbody>
              
          
          
          
          <tr><table  role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate; font-family: 'Inter'; min-width: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; margin: 0 auto; padding: 17px 60px; background-color: #ec632d;" width="100%">
          <tbody style="font-family: 'Inter';"><tr style="font-family: 'Inter';">
            <td class="align-center" style="font-family: 'Inter'; font-size: 14px;" valign="center" align="left">
              <a target="_blank" rel="noopener noreferrer" href="#" style="color: #5daf60; font-family: 'Inter'; text-decoration: underline;">
              <img src="https://toeducate2trade.cloud/logo.PNG" width="" height="82.45">
              </a>
            </td>
          </tr>
        </tbody></table></tr>
          
          
          
          


              <tr><td style="padding: 40px 25px">
              <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Dear ${userIn.full_name}</td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">We would like to inform you that your ${foundDeposit.wallet.toUpperCase()} payment for $${foundDeposit.amount} has been added
              into your Vintage Guarantee account with your earnings altogether.
            </td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">You can now wait for ${Math.floor(parseInt(foundDeposit.duration) / 3600)} hours before you will be eligible to withdraw or reinvest earnings on Vintage Guarantee.</td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Transaction details:</td>
              </tr><tr><td style="padding: 40px 15px; background-color: #ec632d;" bgcolor="#ec632d">
              <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Amount</td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${amount} USD</td>
              </tr><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Wallet</td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${foundDeposit.wallet.toUpperCase()}</td>
              </tr><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Plan</td>
              </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${foundDeposit.plan.name.toUpperCase()}</td>
              </tr></tbody></table></td>
              </tr>
              </tbody></table></td>
              </tr><tr><td bgcolor="#12326b">
              
              <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td class="m_8716275206429255507img-flex"><img style="vertical-align: top; height: auto; width: 600px" src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/img-line.png" width="600" border="0"></td>
              </tr><tr><td style="padding: 60px 15px; padding-top: 0;" bgcolor="#12326b">
              <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="padding: 0 0 40px">
              <table style="margin: 0 auto" cellspacing="0" cellpadding="0" align="center"><tbody>
              
            
            
            
              <tr>
            </tr></tbody></table></td>
            </tr>
                 
            <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px">Don't recognize this activity? <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Report it</a> immediately.</td>
            </tr>
            <tr><td class="m_8716275206429255507h-u" style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff">To the moon 🚀<br> TEAM TOEDUCATE2TRADE<br><br> Questions? Visit the <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Help Centre</a>.</td>
            </tr>
            
            
              
              </tbody></table></td>
              </tr></tbody></table></td>
              </tr></tbody></table></td>
              </tr></tbody></table></td>
              </tr></tbody></table>
          
          `,
        }
      



    const createNot = await Notification.create({
      obj: [
        {
          key: "Plan",
          value: foundDeposit.plan.name.toUpperCase(),
        },
        { key: "Wallet", value: foundDeposit.wallet.toUpperCase() },
        { key: "Amount", value: `${amount} USD` },
      ],
      note: `Your payment for $${foundDeposit.amount} has been added into your Vintage Guarantee account successfully. You can now wait for ${Math.floor(parseInt(foundDeposit.duration) / 3600)} hours before you will be eligible to withdraw or reinvest earnings on Vintage Guarantee.`,
      // owner the person that owns this model
      owner: req.params.user_id,
    });


      const mailOptions = {
        from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
        to: msg.to,
        subject: msg.subject,
        html: msg.html,
      };
  
      const dataHere = await transporter.sendMail(mailOptions);
  
  

      // const resendMsg = await resend.emails.send({
      //   from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
      //   to: msg.to,
      //   subject: msg.subject,
      //   html: msg.html,
      // });
  
      // console.log("resendMsg ==>> ", resendMsg);
    } catch (error) {
      console.log(error);
      res.status(500).json({
        error: true,
        data: null,
        msg: "oops!!!, an unknown error occured in the server, please try again in few minutes",
      });
    }
  }
);

module.exports = Router;
