const AuthAdmin = require("../../../middlewares/authAdmin");
const deposit = require("../../../model/deposit");
const user = require("../../../model/user");
const Router = require("express").Router();

Router.delete("/:deposit_id", AuthAdmin, async (req, res) => {
  try {
    let { deposit_id } = req.params;
    let foundDeposit = await deposit
      .findOne({ _id: deposit_id })
      .populate("uid");
    //after finding the deposit
    if (!foundDeposit)
      return new Error(
        "Unable to complete request, please try again in 5 minutes"
      );
    // remove pending deposit from user schema || profile
    await user.updateOne(
      { email: foundDeposit.uid.email },
      {
        pending_deposit:
          +foundDeposit.uid.pending_deposit - foundDeposit.amount,
        // wallet: {
        //     ...foundDeposit.user.wallet,
        //     [foundDeposit.wallet]: {
        //         pending_deposit: foundDeposit.user.wallet[foundDeposit.wallet].pending_deposit - foundDeposit.amount,
        //     }
        // }
      }
    );
    //delete the found deposit
    await deposit.deleteOne({ _id: deposit_id }); //delete the deposit
    res.json({
      error: false,
      data: "Deposit delete process has been completed",
    });
    //FIXME: Email the customer about the delete request
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "unable to complete request, please contact server admin.",
      data: null,
    });
  }
});

module.exports = Router;
