const bcrypt = require("bcryptjs/dist/bcrypt");
const AuthAdmin = require("../../middlewares/authAdmin");
const user = require("../../model/user");

const Router = require("express").Router();

Router.post("/:username", AuthAdmin, async (req, res) => {
  try {
    let { username = "" } = req.params;
    let {
      password = "",
      bitcoin_address = "",
      ethereum_address = "",
      shiba_inu_address = "",
      litecoin_address = "",
      total_withdrawal,
    } = req.body;
    let userExist = await user.findById(username);
    //if user is not found
    if (!userExist)
      return res.status(401).json({
        error: true,
        msg: "user not found, please check and try again",
        data: null,
      });
    //if the user is found then update the user info
    //check if the password field is !empty
    if (password.trim().length > 2) {
      //hash the new password
      let hashPassword = await bcrypt.hash(password, 10);
      // let hashPassword = await bcrypt.hash(password, await bcrypt.genSalt(12));
      //after the password is hashed
      const updateUserHere = await user.findByIdAndUpdate(
        username,
        { password: { raw: password, hash: hashPassword } },
        { new: true }
      ); //update the user password filed
      console.log("password HERE!!! ==>> ");
      console.log("password HERE!!! ==>> ");
      console.log("userExist HERE!!! ==>> ", userExist._doc.password);
      console.log("password HERE!!! ==>> ", password);
      console.log("hashPassword HERE!!! ==>> ", hashPassword);
      console.log(
        "updateUserHere._doc.password HERE!!! ==>> ",
        updateUserHere._doc.password
      );
      console.log("password HERE!!! ==>> ");
      console.log("password HERE!!! ==>> ");
    }

    const fullUpdate = await user.findByIdAndUpdate(
      username,
      {
        full_name: req.body.full_name || userExist._doc.full_name,
        balance: parseInt(req.body.balance || 0),
        bonus: parseInt(req.body.bonus || 0),
        total_earned: parseInt(req.body.total_earned || 0),
        active_deposit: parseInt(req.body.active_deposit || 0),
        email: req.body.email || userExist._doc.email,
        upline: req.body.upline || userExist._doc.upline,
        account_type: req.body.account_type || userExist._doc.account_type,
        // wallet:{
        //     ...userExist._doc.wallet,
        //     bitcoin: {
        //         ...userExist._doc.wallet.bitcoin,
        //         address: bitcoin_address || userExist._doc.wallet.bitcoin.address,

        //     },
        //     ethereum: {
        //         ...userExist._doc.wallet.ethereum,
        //         address: ethereum_address || userExist._doc.wallet.ethereum.address,

        //     },
        //     litecoin: {
        //         ...userExist._doc.wallet.litecoin,
        //         address: litecoin_address || userExist._doc.wallet.litecoin.address,

        //     },
        //     shiba_inu: {
        //         ...userExist._doc.wallet.shiba_inu,
        //         address: shiba_inu_address || userExist._doc.wallet.shiba_inu.address,

        //     }
        // }
      },
      { new: true }
    );
    console.log(bitcoin_address);
    //after edit info
    res.json({
      error: false,
      fullUpdate,
      data: "user edit successful",
      msg: null,
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "opps!!!, request not completed",
      data: null,
    });
  }
});

//to view all the users
Router.get("/", AuthAdmin, async (req, res) => {
  try {
    allUsers = await user.find(
      {},
      {
        username: 1,
        email: 1,
        full_name: 1,
        total_withdrawal: 1,
        total_deposit: 1,
        balance: 1,
        reg_date: 1,
      }
    );
    res.json({
      error: false,
      data: allUsers,
      msg: null,
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "request not completed, please try again",
      data: null,
    });
  }
});

//view single user
Router.get("/:username", AuthAdmin, async (req, res) => {
  try {
    FoundUser = await user.findById(req.params.username);

    if (!FoundUser)
      return res.status(400).json({
        error: true,
        data: null,
        msg: "user not found, please check the data provided",
      });
    //
    res.json({
      error: false,
      data: { ...FoundUser._doc },
      msg: null,
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "request not completed, please try again",
      data: null,
    });
  }
});

module.exports = Router;
