const AuthAdmin = require('../../../middlewares/authAdmin');
const user = require('../../../model/user');

const Route = require('express').Router()



//add bonus for one user 
Route.post('/add-transaction-by-username', AuthAdmin, async(req,res)=>{
    try {
        //this route is to handle single sender using thier username 
        let {username,payment_system,amount,transaction_type} = req.body;
        let foundUser = await user.findOne({username})
        if(!foundUser) return res.status(401).json({error:true,msg:'invalid username provided, please check and send again',data:null})
        //if the user is found in the database 
        await user.updateOne({username},{
            balance: foundUser._doc.balance + amount,
            wallet: {
                ...foundUser._doc.wallet,
                [payment_system]:{
                    ...foundUser._doc.wallet[payment_system],
                    balance: foundUser._doc.wallet[payment_system].balance + amount
                }
            }
        })
        //after updating the balance of the user then respond to the user 
        res.json({
            data: 'request completed, funds sent to client',
            error: false,
            msg: null
        })
        //send email to client 

    } catch (error) {
        console.log(error);
        res.status(500)
        .json({
            error: true,
            msg: 'opps!, an unknown error occurred'
        })
    }
})






//add bonus for multi user
Route.post('/add-transaction-by-group', AuthAdmin, async(req,res)=>{
    try {
        //this route is to handle single sender using thier username 
        let {usernames=[],payment_system,amount,transaction_type} = req.body;
        //map through the current users in the database then update them 
        usernames.map(username=> async function(){
            let foundUser = await user.findOne({username})
            await user.updateOne({username},{
                balance: foundUser._doc.balance + amount,
                wallet: {
                    ...foundUser._doc.wallet,
                    [payment_system]:{
                        ...foundUser._doc.wallet[payment_system],
                        balance: foundUser._doc.wallet[payment_system].balance + amount
                    }
                }
            })
        }())

        //TODO: send email to all the users for the transaction 

        res.status(200).json({
            error:true,
            data: 'request completed, users will receive email notifications'
        })



        //if the user is found in the database 
        // await user.updateMany({usernames},{
        //     balance: foundUser._doc.balance + amount,
        //     wallet: {
        //         ...foundUser._doc.wallet,
        //         [payment_system]:{
        //             ...foundUser._doc.wallet[payment_system],
        //             balance: foundUser._doc.wallet[payment_system].balance + amount
        //         }
        //     }
        // })
        //after updating the balance of the user then respond to the user 
        res.json({
            data: 'request completed, funds sent to client',
            error: false,
            msg: null
        })
        //send email to client 

    } catch (error) {
        console.log(error);
        res.status(500)
        .json({
            error: true,
            msg: 'opps!, an unknown error occurred'
        })
    }
})






module.exports = Route;