const AuthAdmin = require("../../../middlewares/authAdmin");
const { sgMail } = require("../../../middlewares/mailer");
const user = require("../../../model/user");
const withdraw = require("../../../model/deposit");

const Router = require("express").Router();

//View all withdrawal in the db
Router.get("/", AuthAdmin, async (req, res) => {
  try {
    let all_withdrawal = await withdraw
      .find({
        uid: {
          $in: await user.find({ suspended: false }),
        },
      })
      .sort({ createdAt: -1 })
      .populate("uid");
    res.json({
      error: false,
      msg: null,
      data: all_withdrawal,
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "Opps!!!, an error was encountered. please try again.",
      data: null,
    });
  }
});

// view single withdrawal
Router.get("/:withdrawal_id", AuthAdmin, async (req, res) => {
  try {
    let foundWithdrawal = await withdraw
      .findOne({ _id: req.params.withdrawal_id })
      .sort({ createdAt: -1 })
      .populate("uid");
    if (!foundWithdrawal)
      return res.status(400).json({
        error: true,
        data: null,
        msg: "withdrawal id not found on db",
      });
    res.json({
      error: false,
      msg: null,
      data: foundWithdrawal,
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "Opps!!!, an error was encountered. please try again.",
      data: null,
    });
  }
});

//confirm withdrawal by id

Router.post("/:withdrawal_id", AuthAdmin, async (req, res) => {
  try {
    let foundWithdrawal = await withdraw
      .findOne({ _id: req.params.withdrawal_id })
      .sort({ createdAt: -1 })
      .populate("uid");
    if (!foundWithdrawal)
      return res.status(400).json({
        error: true,
        data: null,
        msg: "withdrawal not found on server or already confirmed",
      });
    //if the id is found then confirm it
    await withdraw.updateOne(
      { _id: req.params.withdrawal_id },
      {
        status: "completed",
      }
    );
    // console.log("foundWithdrawal._doc.wallet =>>> ", Math.random());
    // console.log("foundWithdrawal._doc.wallet =>>> ", Math.random());
    // console.log("foundWithdrawal._doc.wallet =>>> ", Math.random());
    // console.log("foundWithdrawal._doc.wallet =>>> ", Math.random());
    // console.log("foundWithdrawal._doc.wallet =>>> ", Math.random());
    // console.log("foundWithdrawal._doc.wallet =>>> ", foundWithdrawal);
    // console.log("foundWithdrawal._doc.wallet =>>> ", Math.random());
    // console.log("foundWithdrawal._doc.wallet =>>> ", Math.random());
    // console.log("foundWithdrawal._doc.wallet =>>> ", Math.random());
    // console.log("foundWithdrawal._doc.wallet =>>> ", Math.random());
    // console.log(
    //   foundWithdrawal._doc.user.wallet[foundWithdrawal._doc.wallet] +
    //     " pending "
    // );
    //update the user as well
    await user.findByIdAndUpdate(
      { _id: foundWithdrawal.uid._id },
      {
        pending_withdrawal:
          parseInt(foundWithdrawal.uid.pending_withdrawal) -
          parseInt(foundWithdrawal.amount),
        total_withdrawal:
          parseInt(foundWithdrawal.amount) +
          parseInt(foundWithdrawal.uid.total_withdrawal),
        // wallet: {
        //     ...foundWithdrawal._doc.user.wallet,
        //     [foundWithdrawal._doc.wallet]:{
        //         ...foundWithdrawal._doc.user.wallet[foundWithdrawal._doc.wallet],
        //         pending_withdrawal: (foundWithdrawal._doc.user.wallet[foundWithdrawal._doc.wallet].pending_withdrawal - foundWithdrawal._doc.user.pending_withdrawal)
        //     }
        // }
      },
      { new: true }
    );
    //resolve
    res.status(201).json({
      error: false,
      data: "withdrawal confirmed, request completed",
      msg: null,
    });

    //send email to user here
    // sgMail.send({
    //     from: "Driili <support@driili-investment.com>",
    //     to: foundWithdrawal._doc.user.email,
    //     subject: "Withdrawal Sent",
    //     html: `<table class="m_8716275206429255507flexible" style="margin: 0 auto" width="600" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td bgcolor="#ffffff">
    //     <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td class="m_8716275206429255507img-flex"><img src="https://driili-investment.com/headSection.png" width="600" height="200"></td>
    //     </tr><tr><td style="padding: 40px 25px">
    //     <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Hello ${foundWithdrawal._doc.user.full_name}</td>
    //     </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">We've processed your Deposit and  USD ${amount} will be added to your account.</td>
    //     </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">It may take up to <strong style="color: #12326b">an hour</strong>&nbsp;for it to reflect in your (BTC)  wallet  <strong style="color: #12326b">${foundWithdrawal._doc.user.wallet.bitcoin.address}</strong> due to network confirmations. Please confirm from your wallet.</td>
    //     </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Transaction details:</td>
    //     </tr><tr><td style="padding: 40px 15px; border-radius: 10px" bgcolor="#F2F2F2">
    //     <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #12326b" align="center">Amount</td>
    //     </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px" align="center">USD ${foundWithdrawal._doc.amount}</td>
    //     </tr><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #12326b" align="center">Fee</td>
    //     </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px" align="center">USD 0</td>
    //     </tr></tbody></table></td>
    //     </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Don't recognize this activity? <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Report it</a> immediately.</td>
    //     </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">If you made a mistake sending this crypto <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">read this article</a> on what you can do.</td>
    //     </tr><tr><td class="m_8716275206429255507h-u" style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000">To the moon 🚀<br> Team Perfect Profit Point<br><br> Questions? Visit the <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Help Centre</a>.</td>
    //     </tr></tbody></table></td>
    //     </tr><tr><td bgcolor="#12326b">
    //     <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td class="m_8716275206429255507img-flex"><img style="vertical-align: top; height: auto; width: 600px" src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/img-line.png" width="600" border="0"></td>
    //     </tr><tr><td style="padding: 60px 15px" bgcolor="#12326b">
    //     <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="padding: 0 0 40px">
    //     <table style="margin: 0 auto" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td class="m_8716275206429255507active"><a href="https://itunes.apple.com" rel="noreferrer" target="_blank"> <img src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/btn-app.png" alt="Download on the App Store" width="136" height="41"></a></td>
    //     <td class="m_8716275206429255507w-10" width="30">&nbsp;</td>
    //     <td class="m_8716275206429255507active"><a href="https://play.google.com" rel="noreferrer" target="_blank"> <img src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/btn-gp.png" alt="Get it on Google Play" width="136" height="41"></a></td>
    //     </tr></tbody></table></td>
    //     </tr><tr><td class="m_8716275206429255507h-u" style="font: 15px/20px Arial,Helvetica,sans-serif; color: #ffffff; padding: 0 0 40px" align="center">You received this email because an account was registered for Perfect Profit Point&nbsp;<br class="m_8716275206429255507hide"> using the address ${foundWithdrawal._doc.user.email}</td>
    //     </tr><tr><td style="padding: 0 0 10px">
    //     <table style="margin: 0 auto" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td class="m_8716275206429255507active"><a href="https://www.facebook.com/" rel="noreferrer" target="_blank"><img src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/ico-fb.png" alt="FB" width="22" height="22"></a></td>
    //     <td width="25">&nbsp;</td>
    //     <td class="m_8716275206429255507active"><a href="https://www.twitter.com/" rel="noreferrer" target="_blank"><img src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/ico-tw.png" alt="TW" width="22" height="18"></a></td>
    //     <td width="25">&nbsp;</td>
    //     <td class="m_8716275206429255507active"><a href="https://www.linkedin.com/" rel="noreferrer" target="_blank"><img src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/ico-in.png" alt="LN" width="22" height="22"></a></td>
    //     </tr></tbody></table></td>
    //     </tr><tr><td style="padding: 0 0 10px">
    //     <table style="margin: 0 auto" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td class="m_8716275206429255507active"><a href="https://www.youtube.com/" rel="noreferrer" target="_blank"><img src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/ico-yt.png" alt="YT" width="22" height="16"></a></td>
    //     <td width="25">&nbsp;</td>
    //     <td class="m_8716275206429255507active"><a href="https://medium.com/" rel="noreferrer" target="_blank"><img src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/ico-m.png" alt="M" width="22" height="17"></a></td>
    //     <td width="25">&nbsp;</td>
    //     <td class="m_8716275206429255507active"><a href="https://www.instagram.com" rel="noreferrer" target="_blank"><img src="https://d32exi8v9av3ux.cloudfront.net/static/images/email/best_trip/ico-ig.png" alt="IG" width="22" height="22"></a></td>
    //     </tr></tbody></table></td>
    //     </tr></tbody></table></td>
    //     </tr></tbody></table></td>
    //     </tr></tbody></table></td>
    //     </tr></tbody></table>`
    // })
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      data: null,
      msg: "requested not completed",
    });
  }
});

//delete withdrawal
Router.delete("/:withdrawal_id", AuthAdmin, async (req, res) => {
  try {
    let foundWithdrawal = await withdraw
      .findOne({ _id: req.params.withdrawal_id })
      .sort({ createdAt: -1 })
      .populate("uid");
    if (!foundWithdrawal)
      return res.status(400).json({
        error: true,
        data: null,
        msg: "withdrawal not found on server or already confirmed",
      });
    //if the id is found then confirm it
    await withdraw.deleteOne({ _id: req.params.withdrawal_id }); //delete
    console.log(foundWithdrawal._doc.wallet);

    //update the user as well
    await user.updateOne(
      { username: foundWithdrawal.uid.username },
      {
        pending_withdrawal:
          +foundWithdrawal._doc.uid.pending_withdrawal -
          +foundWithdrawal._doc.amount,
        // wallet: {
        //     ...foundWithdrawal._doc.user.wallet,
        //     [foundWithdrawal._doc.wallet]:{
        //         ...foundWithdrawal._doc.user.wallet[foundWithdrawal._doc.wallet],
        //         pending_withdrawal: (foundWithdrawal._doc.user.wallet[foundWithdrawal._doc.wallet].pending_withdrawal - foundWithdrawal._doc.user.pending_withdrawal)
        //     }
        // }
      }
    );
    //resolve
    res.status(201).json({
      error: false,
      data: "withdrawal deleted, request completed",
      msg: null,
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      data: null,
      msg: "requested not completed",
    });
  }
});

module.exports = Router;
