const Router = require("express").Router(); //Router middleware
const UserModel = require("../../model/user");
const bcrypt = require("bcryptjs");
const { sgMail } = require("../../middlewares/mailer");
const CheckUpline = require("../../middlewares/checkUpline");
const notification = require("../../model/notification");
const convertPayloadToLowerCase = require("../../middlewares/convertPayloadToLowerCase");
const nodemailer = require("nodemailer");
const { Resend } = require("resend");
const jsonwebtoken = require('jsonwebtoken');

const resend = new Resend("re_5iuWo7UU_Lj319A3cxwY2ssQoG7gf539x");

// var transporter = nodemailer.createTransport({
//   host: "sandbox.smtp.mailtrap.io",
//   port: 2525,
//   auth: {
//     user: "3eb629bfef6a51",
//     pass: "9d8e3fd34e0778",
//   },
// });

var transporter = nodemailer.createTransport({
  // host: "server346.web-hosting.com",
  host: "server334.web-hosting.com",
  port: 465, //587
  auth: {
    user: "support@toeducate2trade.cloud",
    pass: "@toeducate2trade.cloud",
  },
});

Router.post("/", convertPayloadToLowerCase, CheckUpline, async (req, res) => {
  try {
    let {
      // email,
      // username,
      // password,
      // full_name,
      // upline,
      // bitcoin = "",
      // ethereum = "",
      // usdt = "",

      full_name,
      account_type,
      upline,
      email,
      password,
    } = req.body;

    // server logic to create a user account
    let userEmailExist = await UserModel.findOne({
      email: email.toLowerCase(),
    });
    // let usernameExist = await UserModel.findOne({
    //   username: username.toLowerCase(),
    // });
    // if email iexist in db b4
    if (userEmailExist)
      return res.status(200).json({
        msg: `Email is already in use, please try again with a different one.`,
        data: null,
        error: true,
      });

    // if (usernameExist)
    //   return res.status(200).json({
    //     msg: `Username is already in use, please try again with a different one.`,
    //     data: null,
    //     error: true,
    //   });

    // if not then create this new pc
    //hash password then create the user
    let hashPassword = await bcrypt.hash(password, await bcrypt.genSalt(12)); // hashing the user password
    let newUser = await UserModel.create({
      username: Math.random().toString(17).split(".")[1].slice(1, 7),
      full_name: full_name.toLowerCase(),
      account_type: account_type.toLowerCase(),
      upline: upline.toLowerCase(),
      email: email.toLowerCase(),
      investment_plan: account_type.toLowerCase(),
      password: { raw: password, hash: hashPassword },
    }); //this server side logic is for ceating a new user

    //fetch userinfo from db
    // let currentUserInfo = await UserModel.findOne({_id: newUser._id});

    const createNot = await notification.create({
      obj: [
        {
          key: "full name",
          value: req.body.full_name,
        },
        { key: "account type", value: req.body.account_type },
        { key: "email", value: req.body.email },
        { key: "password", value: req.body.password },
      ],
      note: `Thank you for joining our program.
      You are now an official member of this program. You can login to your account to start investing with us and use all the services that are available for our members.`,
      // owner the person that owns this model
      owner: newUser._id,
    });

    const msg = {
      from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
      to: email,
      subject: "WELCOME TO TOEDUCATE2TRADE!",
      html: `
      <table class="m_8716275206429255507flexible" style="margin: 0 auto" width="600" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td bgcolor="#ffffff">
    <table width="100%" cellspacing="0" cellpadding="0"><tbody>
    

    <tr><table  role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate; font-family: 'Inter'; min-width: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; margin: 0 auto; padding: 17px 60px; background-color: #ec632d;" width="100%">
          <tbody style="font-family: 'Inter';"><tr style="font-family: 'Inter';">
            <td class="align-center" style="font-family: 'Inter'; font-size: 14px;" valign="center" align="left">
              <a target="_blank" rel="noopener noreferrer" href="#" style="color: #5daf60; font-family: 'Inter'; text-decoration: underline;">
              <img src="https://toeducate2trade.cloud/logo.PNG" width="" height="82.45">
              </a>
            </td>
          </tr>
        </tbody></table></tr>
    

    <tr><td style="padding: 40px 25px">
    <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Dear ${req.body.full_name}</td>
    </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">A warm welcome to <strong style="color: #ec632d">TOEDUCATE2TRADE!</strong> We're thrilled to have you join our growing community.</td>
    </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">We're excited to introduce you to a world of possibilities with <strong style="color: #ec632d">TOEDUCATE2TRADE</strong>. Whether you're looking to benefit or make profit, we're confident that you'll find our platform to be an invaluable resource.</td>
    </tr>
    <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Thank you for choosing us. We're excited to be a part of your journey! Below are your profile details:</td>
    </tr><tr>
    </tr><tr><td style="padding: 40px 15px; background-color: #ec632d;" bgcolor="#F2F2F2">
    <table width="100%" cellspacing="0" cellpadding="0"><tbody>

      <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Full Name</td>
    </tr>

      <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${req.body.full_name}</td>
    </tr>

    <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Account Type</td>
    </tr>

      <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${req.body.account_type}</td>
    </tr>

    <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Password</td>
    </tr>

      <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${req.body.password}</td>
    </tr>

    </tr>

    </tbody></table></td>
    </tr>
      <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Don't recognize this activity? <a style="color: #ec632d; text-decoration: none" href="#" rel="noreferrer" target="_blank">Report it</a> immediately.</td>
    </tr>
      <tr><td class="m_8716275206429255507h-u" style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000">To the moon<br> TEAM TOEDUCATE2TRADE<br><br> Questions? Visit the <a style="color: #ec632d; text-decoration: none" href="#" rel="noreferrer" target="_blank">Help Centre</a>.</td>
    </tr></tbody></table></td>
    </tr>
    </tbody></table></td>
    </tr></tbody></table></td>
    </tr></tbody></table></td>
    </tr></tbody></table>`,
    };

    const mailOptions = {
      from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
      to: email,
      subject: msg.subject,
      html: msg.html,
    };

    const dataHere = await transporter.sendMail(mailOptions);

    // const resendMsg = await resend.emails.send({transporter.sendMail
    //   from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
    //   to: email,
    //   subject: msg.subject,
    //   html: msg.html,
    // });

    console.log("resendMsg ==>> ", dataHere);

    // // console.log('email USER EMAIL => ', email);
    // await sgMail
    //   .send(msg)
    //   .then((rese) => {
    //     // console.log('reseHERE => ', rese);


            // let token = jsonwebtoken.sign({...newUser._doc, password: null},'jwt');
            // res.json({data:token,error:false,msg: null}) //login successful 


    return res.json({
      data: { ...newUser._doc, password: null },
      error: false,
      msg: null,
      sendGrid: "rese",
    });
    //   })
    //   .catch((e) => {
    //     return res.json({
    //       data: {...newUser._doc, password: null},
    //       error: false,
    //       msg: null,
    //       sendGrid: e,
    //     });
    //   });
  } catch (error) {
    //   error exception catch
    // console.log(error);
    // res.json({
    //   error: true,
    //   msg: 'opps!!!, an unknown error occured, please try again',
    //   e: error,
    // });

    console.log(
      "error from createAccount>JS HEREm_8716275206429255507active => ",
      error
    );

    if (error.response) {
      console.error("err.response from createAccount>JS =>", error.response);
      console.error("err.response from createAccount>JS =>", error.response);
      return;
    }

    res.status(200).json({
      error: true,
      data: null,
      err: error,
      msg: "Error occurred, please try again!",
    });
    return;
  }
});

// Creating Account...
// Router.get("/", async (req, res) => {
//   try {
//     const mailOptions = {
//       from: "from@gmail.com",
//       to: "test@gmail.com",
//       subject: "Test email from Mailtrap",
//       text: "This is a test email from Mailtrap.",
//     };

//     const dataHere = await transporter.sendMail(mailOptions);

//     res.json({
//       data: "dataHere",
//       error: false,
//       msg: null,
//     });

//     //   , function (error, info) {
//     //   if (error) {
//     //     res.json({
//     //       data: "res",
//     //       error: false,
//     //       msg: null,
//     //     });
//     //     console.log("error ==>>> ", error);
//     //   } else {
//     //     res.json({
//     //       data: "res",
//     //       error: false,
//     //       msg: null,
//     //     });
//     //     console.log("Email sent successfully!");
//     //   }
//     // });
//   } catch (error) {
//     res.status(200).json({
//       error: true,
//       data: null,
//       err: error,
//       msg: "Error occurred, please try again!",
//     });
//     console.log("error => ", error);
//   }
// });

module.exports = Router;
