const AuthAdmin = require('../../../middlewares/authAdmin');
const AuthUserToken = require('../../../middlewares/authUser');
const deposit = require('../../../model/deposit');
const user = require('../../../model/user');

const Router = require('express').Router();


// LIST DEPOSIT BY A SPECIFIC USER USING ID {}

Router.get('/', AuthUserToken, async (req,res)=> {
    try {
        let {_id} = req.user;
        let allDepositByUser = await deposit.find({user: _id}).sort({'date':-1})
        res.json({allDepositByUser,total:allDepositByUser.length})
    } catch (error) {
        console.log(error);
        res.status(401)
        .json({
            error:true,
            data:null,
            msg: 'unable to complete action, an error was encountered.'
        })
    }
})







module.exports = Router;