const AuthUserToken = require('../../../middlewares/authUser')
const UserModel = require('../../../model/user')
const depositModel = require('../../../model/deposit')

const Router = require('express').Router()


// CREATE DEPOSIT FOR A USER USING EXISTING BALANCE 
Router.post('/', AuthUserToken, async (req,res)=> {
    let {amount,plan,wallet,remark='THIS IS A TOPUP',earning=0} = req.body; //wallet e.g btc or eth 
    let user = req.user._id; //user in session id 
    // TRY 
    // 
    try {
        console.log(req.user.wallet[wallet]);
        // check if user balance is enough 
        if(amount>req.user.wallet[wallet].balance || amount > req.user.balance ) return res.status(400).json({error:true, data:null,data:'Insuffcient funds in selected wallet, please top up balance and try again.'})
        let newWalletBalance = req.user.wallet[wallet].balance - amount;
        let newMainBalance = req.user.balance - amount;

        let newDeposit = await depositModel.create({amount,user,wallet,remark, plan,earning,isTopUp:true }) //creating a new deposit in the system 
        await UserModel.updateOne({_id:user}, {
            balance:newMainBalance,
            pending_deposit: req.user.pending_deposit + amount,
            wallet: {
                ...req.user.wallet,
                [wallet]:{
                    ...req.user.wallet[wallet],
                    balance: newWalletBalance,
                    pending_deposit:req.user.wallet[wallet].pending_deposit + amount
                }
            }
        })
        res.json({error:false,data:'Deposit sucessful, awaiting approval.',msg:null,token:req.token})
        //TODO: email the user to notify him about the  deposit request
        console.log(newDeposit);
    } 
    // CATCH BLOCK 
    catch (error) {
        console.log(error);
        return res.status(500).json({error:true, msg: 'opps!!!, unable to complete deopsit request, please try agin in 3minutes',data:null,e:error})
    }
})

 

module.exports = Router;


 