const jsonwebtoken = require("jsonwebtoken");
const AuthUserToken = require("../../middlewares/authUser");
const UserModel = require("../../model/user");
const DepositModel = require("../../model/deposit");
const Router = require("express").Router();
const moment = require("moment");

Router.get("/", AuthUserToken, async (req, res) => {
  try {
    const getUser = await UserModel.findOne({ _id: req.user._id }).select(
      "-password"
    );
    let token = jsonwebtoken.sign({ ...getUser._doc, password: null }, "jwt");

    // get active_deposit
    const getAllDeposit = await DepositModel.find({
      type: "deposit",
      uid: getUser._id,
      status: "completed",
    });

    const totalAmount = getAllDeposit.reduce((total, item) => {
      const planEndDate = moment(item.date).add(item.plan.time || 3, "days"); // add plan time (in days)
      const currentDate = moment(); // get the current date

      // If the plan's end date is in the future, add the amount to the total
      if (planEndDate.isAfter(currentDate)) {
        return total + item.amount;
      }

      return total;
    }, 0);

    res.json({
      data: token,
      user: { ...getUser._doc, ac_deposit: totalAmount },
      error: false,
      msg: null,
    });
  } catch (error) {
    // log error
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "request terminated, please try again later",
      data: null,
    });
  }
});

module.exports = Router;
