const { Router } = require("express");
const verifySession = require("../../middlewares/authUser");
const convertPayload2Lowercase = require("../../middlewares/convertPayloadToLowerCase");
const kycModel = require("../../model/kyc.model");
const router = Router();
var multipart = require("connect-multiparty");
var multipartMiddleware = multipart();
const moment = require("moment");

var cloudinary = require("cloudinary").v2;

cloudinary.config({
  cloud_name: "damrxxkrp",
  api_key: "677873915852572",
  api_secret: "aS6xTEMcu9JSkiN-DMsZtxf0rXY",
  secure: true,
});

router.post(
  "/set/kyc",
  multipartMiddleware,
  convertPayload2Lowercase,
  verifySession,
  async (req, res) => {
    try {
      const {
        full_name,
        email,
        country,
        phone,
        address,
        zip,
        dob,
        marital_status,
        id_card_type,
      } = req.body;

    //   console.log("req.body =>>> ", req.body);
    //   console.log("req.files =>>> ", req.files);

      let uploadingImg;
      const main_id =
        Math.random().toString(20).split("")[4] +
        Math.random().toString(20).split("")[5] +
        Math.random().toString(20).split("")[3] +
        Math.random().toString(20).split("")[6] +
        Math.random().toString(20).split("")[7] +
        Math.random().toString(20).split("")[8] +
        Math.random().toString(20).split("")[3];

      if (req.files.photo) {
        uploadingImg = await cloudinary.uploader.upload(req.files.photo.path, {
          folder: "kyc",
        });
        if (!uploadingImg) {
          return res.status(200).json({
            e: true,
            m: "error uploading picture file",
          });
        }
      }

      const createNewTicket = await kycModel.create({
        full_name,
        email,
        country,
        phone,
        address,
        zip,
        id_card_type,
        dob,
        marital_status,
        uid: req.user._id,
      });

      if (uploadingImg?.url) {
        createNewTicket.photo = uploadingImg?.url;
        createNewTicket.image = uploadingImg;

        await createNewTicket.save();
      }

      // console.log("updateData => ", updateData);
      // console.log("req.body => ", req.body);

      res.status(201).json({
        e: false,
        m: "KYC submitted successfully.",
        data: createNewTicket,
      });
    } catch (error) {
      res.status(500).json({
        e: true,
        m: error.message || "Unable to complete request",
      });
      console.log(error);
    }
  }
);

router.get(
  "/check/kyc/status",
  convertPayload2Lowercase,
  verifySession,
  async (req, res) => {
    try {
      const findKYC = await kycModel.findOne({ uid: req.user._id });

      if (!findKYC) {
        return res.status(200).json({
          e: false,
          data: "unverified",
          m: "success",
        });
      }

      res.status(200).json({
        e: false,
        m: "success",
        data: findKYC.status,
      });
    } catch (error) {
      res.status(500).json({
        e: true,
        m: error.message || "Unable to complete request",
      });
      console.log(error);
    }
  }
);

module.exports = router;