const AuthUserToken = require("../../../middlewares/authUser");
const { sgMail } = require("../../../middlewares/mailer");
const user = require("../../../model/user");
const withdraw = require("../../../model/withdraw");
const deposit = require("../../../model/deposit");
const Router = require("express").Router();
const nodemailer = require("nodemailer");
const Notification = require("../../../model/notification");
const { Resend } = require("resend");

const resend = new Resend("re_5iuWo7UU_Lj319A3cxwY2ssQoG7gf539x");

// var transporter = nodemailer.createTransport({
//   host: "sandbox.smtp.mailtrap.io",
//   port: 2525,
//   auth: {
//     user: "3eb629bfef6a51",
//     pass: "9d8e3fd34e0778",
//   },
// });

var transporter = nodemailer.createTransport({
  // host: "server346.web-hosting.com",
  host: "server334.web-hosting.com",
  port: 465, //587
  auth: {
    user: "support@toeducate2trade.cloud",
    pass: "@toeducate2trade.cloud",
  },
});

// ASK FOR WITHDRAWAL
Router.post("/", AuthUserToken, async (req, res) => {
  try {
    const findUser = await user.findById(req.user._id);
    if (!findUser)
      return res.status(500).json({ error: true, msg: "Can't find user" });

    let { amount, plan, wallet } = req.body;
    if (amount > findUser.balance)
      return res.status(400).json({
        error: true,
        data: null,
        msg: "Insufficient funds in  wallet, please fund your account and try again. ",
      });
    console.log(req.user.balance);
    // let newWithdrawal = await withdraw.create({user:req.user._id, amount, wallet})
    let newWithdrawal = await deposit.create({
      amount,
      plan,
      wallet,
      type: "withdrawal",
      status: "processing",
      uid: req.user._id,
    });
    //after creating the withdrawal then debit the user account
    await user.updateOne(
      { _id: req.user._id },
      {
        balance: parseInt(req.user.balance) - parseInt(amount),
        pending_withdrawal:
          parseInt(req.user.pending_withdrawal) + parseInt(amount),
        // wallet: {
        //     ...req.user.wallet,
        //     [wallet]: {
        //         ...req.user.wallet[wallet],
        //         balance: req.user.wallet[wallet].balance - amount,
        //         pending_withdrawal: req.user.wallet[wallet].pending_withdrawal + amount
        //     }
        // }
      }
    );
    res.json({
      error: false,
      msg: null,
      data: "Withdrawal request has been placed, awaiting admin approval",
      newWithdrawal,
    });
    //FIXME: EMAIL THE USER
    // sgMail.send({
    const msg = {
      from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
      to: req.user.email,
      subject: "Withdrawal request placed",
      html: `
    <table class="m_8716275206429255507flexible" style="margin: 0 auto" width="600" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td bgcolor="#ffffff">
    <table width="100%" cellspacing="0" cellpadding="0"><tbody>
    

    
    <tr><table  role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate; font-family: 'Inter'; min-width: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; margin: 0 auto; padding: 17px 60px; background-color: #ec632d;" width="100%">
          <tbody style="font-family: 'Inter';"><tr style="font-family: 'Inter';">
            <td class="align-center" style="font-family: 'Inter'; font-size: 14px;" valign="center" align="left">
              <a target="_blank" rel="noopener noreferrer" href="#" style="color: #5daf60; font-family: 'Inter'; text-decoration: underline;">
              <img src="https://toeducate2trade.cloud/logo.PNG" width="" height="82.45">
              </a>
            </td>
          </tr>
        </tbody></table></tr>



  <tr><td style="padding: 40px 25px">
    <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Dear ${
      req.user.full_name
    }</td>
    </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Withdrawal request placed, awaiting approval. It may take up to <strong style="color: #12326b">an hour</strong>&nbsp; for it to reflect to your ${plan.wallet.toUpperCase()} wallet due to network confirmations.</br> Please check your history, to know when it has been confirmed. Simply log in to your account and click on transaction history.</td>
    </tr>
    <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">We're confident that you'll be happy with your decision to choose Vintage Guarantee. Thank you for your trust!</td>
    </tr>
    <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Withdrawal transaction details:</td>
    </tr><tr><td style="padding: 40px 15px; border-radius: 10px" bgcolor="#ec632d">
    <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Amount</td>
    </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">USD ${amount}</td>
    </tr><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Wallet</td>
    </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${plan.wallet.toUpperCase()}</td>
    </tr><tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Address</td>
    </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${plan.address.toLowerCase()}</td>
    </tr></tbody></table></td>
    </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Don't recognize this activity? <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Report it</a> immediately.</td>
    </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">If you made a mistake sending this crypto <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">read this article</a> on what you can do.</td>
    </tr><tr><td class="m_8716275206429255507h-u" style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000">To the moon 🚀<br> TEAM TOEDUCATE2TRADE<br><br> Questions? Visit the <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Help Centre</a>.</td>
    </tr></tbody></table></td>
    </tr>
    
    </tbody></table></td>
    </tr></tbody></table></td>
    </tr></tbody></table></td>
    </tr></tbody></table></td>
    </tr></tbody></table>
    `,
    };

    const mailOptions = {
      from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
      to: msg.to,
      subject: msg.subject,
      html: msg.html,
    };

    const dataHere = await transporter.sendMail(mailOptions);

    const createNot = await Notification.create({
      obj: [
        {
          key: "Amount",
          value: amount,
        },
        { key: "Wallet", value: plan.wallet.toUpperCase() },
        { key: "Address", value: plan.address },
      ],
      note: `Withdrawal request placed, awaiting approval. Withdrawal transaction details are below `,
      // owner the person that owns this model
      owner: req.user._id,
    });

    const resendMsg = await resend.emails.send({
      from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
      to: msg.to,
      subject: msg.subject,
      html: msg.html,
    });
    // .then(r=>console.log('EMAIL SENT'))
    // .catch(e=>console.log('EMAIL NOT SENT '))
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      data: null,
      msg: "Unable to process withdrawal at this time, please try again in few minutes",
    });
  }
});

module.exports = Router;
